import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/manual/parts/signes%20and%20rules%20manual/web_view_of_manual.dart';

class TrafficLawsPage extends StatefulWidget {
  final String appBarTitle;

  const TrafficLawsPage({Key? key, required this.appBarTitle})
      : super(key: key);

  @override
  _TrafficLawsPageState createState() => _TrafficLawsPageState();
}

class _TrafficLawsPageState extends State<TrafficLawsPage> {
  late Map<String, String> paths;

  @override
  void initState() {
    if (Config.language == "ru") {
      paths = {
        "Общие положения": "1_PDD/1_obshie_polozhenia.html",
        "Общие обязанности водителей":
            "1_PDD/2_obshie_obyazannosti_voditeley.html",
        "Обязанности водителя при дорожно-транспортном происшествии":
            "1_PDD/3_obazannosti_pri_DTP.html",
        "Обязанности пешеходов": "1_PDD/4_obazannosti_peshehodov.html",
        "Обязанности пассажиров": "1_PDD/5_obazannosti_passajirov.html",
        "Приоритет специальных транспортных средств":
            "1_PDD/6_prioritet_spec_transporta.html",
        "Сигналы светофора и регулировщика":
            "1_PDD/7_signali_svetofora_i_regulirovshika.html",
        "Предупредительные и аварийные сигналы, применение знака аварийной остановки":
            "1_PDD/8_predupreditelnie_i_avariynie_signali_primenenie_znaka_avariynoy_ostanovki.html",
        "Начало движения, маневрирование":
            "1_PDD/9_nacalo_dvijenia_manevrirovanie.html",
        "Расположение транспортных средств на проезжей части":
            "1_PDD/10_raspolojenie_transporta_na_proezjey_chasti.html",
        "Скорость движения": "1_PDD/11_skorost_dvijenia.html",
        "Обгон": "1_PDD/12_obgon.html",
        "Остановка и стоянка": "1_PDD/13_ostanovka_stoyanka.html",
        "Проезд перекрестков": "1_PDD/14_proezd_perekrestkov.html",
        "Регулируемые перекрестки": "1_PDD/15_reguliruemie_perekrestki.html",
        "Нерегулируемые перекрестки":
            "1_PDD/16_nereguliruemie_perekrestki.html",
        "Пешеходные переходы и остановки маршрутных транспортных средств":
            "1_PDD/17_peshehodnie_perehodi_ostanovki_marshrutih_transport.html",
        "Движение через железнодорожные пути":
            "1_PDD/18_dvijenie_cherez_zeleznodorojnie_puti.html",
        "Движение по автомагистралям":
            "1_PDD/19_dvijenie_po_avtomagistralam.html",
        "Движение в жилых зонах": "1_PDD/20_dvijenie_v_jilih_zonah.html",
        "Движение на крутых спусках и подъемах":
            "1_PDD/21_dvijenie_na_krutih_spuskah_podyemah.html",
        "Приоритет маршрутных средств":
            "1_PDD/22_prioritet_marshrutnih_sredstv.html",
        "Пользование внешними световыми приборами":
            "1_PDD/23_polzovanie_vneshnimi_svetovimi_priborami.html",
        "Буксировка механических транспортных средств":
            "1_PDD/24_buksirovka_mehanicheskih_transportnih_sredstv.html",
        "Обучение вождению транспортных средств":
            "1_PDD/25_obuchenie_vojdeniu_transportnih_sredstv.html",
        "Перевозка людей": "1_PDD/26_perevozka_ludey.html",
        "Перевозка грузов": "1_PDD/27_perevozka_gruzov.html",
        "Дополнительные требования к движению велосипедов и гужевых повозок, а также прогону животных":
            "1_PDD/28_dop+trebovania_k_dvijeniu_velosipedistov_i_gujevih_povozok_a_takje_progonu_jivotnih.html",
        "Обязанности должностных лиц и граждан по обеспечению безопасности дорожного движения, выпуску на линию транспортных средств, установке на них номерных и опознавательных знаков":
            "1_PDD/29_obazannosti_doljnostnih_lic_igrajdan.html"
      };
    } else if (Config.language == "uz") {
      paths = {
        "Умумий қоидалар": "1_PDD/1_Umumiy_qoidalar_UZ.html",
        "Ҳайдовчиларнинг умумий мажбуриятлари":
            "1_PDD/2_Haydovchilarning_umumiy_majburiyatlari_UZ.html",
        "Йўл-транспорт ҳодисаси содир бўлганда ҳайдовчининг мажбуриятлари":
            "1_PDD/3_Yol_transport_hodisasi_sodir_bolganda_haydovchining_majburiyatlari_UZ.html",
        "Пиёдаларнинг мажбуриятлари":
            "1_PDD/4_Piyodalarning_majburiyatlari_UZ.html",
        "Йўловчиларнинг мажбуриятлари":
            "1_PDD/5_Yolovchilarning_majburiyatlari_UZ.html",
        "Махсус транспорт воситаларининг имтиёзлари":
            "1_PDD/6_Maxsus_transport_vositalarining_imtiyozlari_UZ.html",
        "Светофор ва тартибга солувчининг ишоралари":
            "1_PDD/7_Svetofor_va_tartibga_soluvchining_ishoralari_UZ.html",
        "Огоҳлантирувчи ва авария ишоралари, авария сабабли тўхташ белгисининг қўлланилиши":
            "1_PDD/8_Ogohlantiruvchi_va_avariya_ishoralari_avariya_sababli_toxtash_belgisining_qollanilishi_UZ.html",
        "Ҳаракатланишни бошлаш, йўналишларни ўзгартириш":
            "1_PDD/9_Harakatlanishni_boshlash_yonalishlarni_ozgartirish_UZ.html",
        "Йўлнинг қатнов қисмида транспорт воситаларининг жойлашуви":
            "1_PDD/10_Yolning_qatnov_qismida_transport_vositalarining_joylashuvi_UZ.html",
        "Ҳаракатланиш тезлиги": "1_PDD/11_Harakatlanish_tezligi_UZ.html",
        "Қувиб ўтиш": "1_PDD/12_Quvib_otish_UZ.html",
        "Тўхташ ва тўхтаб туриш": "1_PDD/13_Toxtash_va_toxtab_turish_UZ.html",
        "Чорраҳада ҳаракатланиш": "1_PDD/14_Chorrahada_harakatlanish_UZ.html",
        "Тартибга солинган чорраҳалар":
            "1_PDD/15_Tartibga_solingan_chorrahalar_UZ.html",
        "Тартибга солинмаган чорраҳалар":
            "1_PDD/16_Tartibga_solinmagan_chorrahalar_UZ.html",
        "Пиёдаларнинг ўтиш жойлари ва йўналишли транспорт воситаларининг бекатлари":
            "1_PDD/17_Piyodalarning_otish_joylari_va_yonalishli_transport_vositalarining_bekatlari_UZ.html",
        "Темир йўл кесишмалари орқали ҳаракатланиш":
            "1_PDD/18_Temir_yol_kesishmalari_orqali_harakatlanish_UZ.html",
        "Автомагистралларда ҳаракатланиш":
            "1_PDD/19_Avtomagistrallarda_harakatlanish_UZ.html",
        "Турар жой даҳаларида ҳаракатланиш":
            "1_PDD/20_Turar_joy_dahalarida_harakatlanish_UZ.html",
        "Тик нишаблик ва баландликларда ҳаракатланиш":
            "1_PDD/21_Tik_nishablik_va_balandliklarda_harakatlanish_UZ.html",
        "Йўналишли транспорт воситаларининг имтиёзлари":
            "1_PDD/22_Yonalishli_transport_vositalarining_imtiyozlari_UZ.html",
        "Ташқи ёритиш асбобларидан фойдаланиш":
            "1_PDD/23_Tashqi_yoritish_asboblaridan_foydalanish_UZ.html",
        "Механик транспорт воситаларини шатакка олиш":
            "1_PDD/24_Mexanik_transport_vositalarini_shatakka_olish_UZ.html",
        "Транспорт воситаларини бошқаришни ўргатиш":
            "1_PDD/25_Transport_vositalarini_boshqarishni_orgatish_UZ.html",
        "Одам ташиш": "1_PDD/26_Odam_tashish_UZ.html",
        "Юк ташиш": "1_PDD/27_Yuk_tashish_UZ.html",
        "Велосипед, мопед ва аравалар ҳаракатланишига, шунингдек ҳайвонларни ҳайдаб ўтишга доир қўшимча талаблар":
            "1_PDD/28_Velosiped_moped_va_aravalar_harakatlanishiga_shuningdek_hayvonlarni_haydab_otishga_doir_qoshimcha_talablar_UZ.html",
        "Мансабдор шахсларнинг ва фуқароларнинг йўл ҳаракати хавфсизлигини таъминлаш, транспорт воситаларини йўлга чиқариш, рақам ва таниқли белгиларини ўрнатиш бўйича мажбуриятлари":
            "1_PDD/29_Mansabdor_shaxslarning_va_fuqarolarning_UZ.html"
      };
    } else if (Config.language == "oz") {
      paths = {
        "Umumiy qoidalar": "1_PDD/1_Umumiy_qoidalar_UZ.html",
        "Haydovchilarning umumiy majburiyatlari":
            "1_PDD/2_Haydovchilarning_umumiy_majburiyatlari_UZ.html",
        "Yo‘l-transport hodisasi sodir bo‘lganda haydovchining majburiyatlari":
            "1_PDD/3_Yol_transport_hodisasi_sodir_bolganda_haydovchining_majburiyatlari_UZ.html",
        "Piyodalarning majburiyatlari":
            "1_PDD/4_Piyodalarning_majburiyatlari_UZ.html",
        "Yo‘lovchilarning majburiyatlari":
            "1_PDD/5_Yolovchilarning_majburiyatlari_UZ.html",
        "Maxsus transport vositalarining imtiyozlari":
            "1_PDD/6_Maxsus_transport_vositalarining_imtiyozlari_UZ.html",
        "Svetofor va tartibga soluvchining ishoralari":
            "1_PDD/7_Svetofor_va_tartibga_soluvchining_ishoralari_UZ.html",
        "Ogohlantiruvchi va avariya ishoralari, avariya sababli to‘xtash belgisining qo‘llanilishi":
            "1_PDD/8_Ogohlantiruvchi_va_avariya_ishoralari_avariya_sababli_toxtash_belgisining_qollanilishi_UZ.html",
        "Harakatlanishni boshlash, yo‘nalishlarni o‘zgartirish":
            "1_PDD/9_Harakatlanishni_boshlash_yonalishlarni_ozgartirish_UZ.html",
        "Yo‘lning qatnov qismida transport vositalarining joylashuvi":
            "1_PDD/10_Yolning_qatnov_qismida_transport_vositalarining_joylashuvi_UZ.html",
        "Harakatlanish tezligi": "1_PDD/11_Harakatlanish_tezligi_UZ.html",
        "Quvib o‘tish": "1_PDD/12_Quvib_otish_UZ.html",
        "To‘xtash va to‘xtab turish":
            "1_PDD/13_Toxtash_va_toxtab_turish_UZ.html",
        "Chorrahada harakatlanish": "1_PDD/14_Chorrahada_harakatlanish_UZ.html",
        "Tartibga solingan chorrahalar":
            "1_PDD/15_Tartibga_solingan_chorrahalar_UZ.html",
        "Tartibga solinmagan chorrahalar":
            "1_PDD/16_Tartibga_solinmagan_chorrahalar_UZ.html",
        "Piyodalarning o‘tish joylari va yo‘nalishli transport vositalarining bekatlari":
            "1_PDD/17_Piyodalarning_otish_joylari_va_yonalishli_transport_vositalarining_bekatlari_UZ.html",
        "Temir yo‘l kesishmalari orqali harakatlanish":
            "1_PDD/18_Temir_yol_kesishmalari_orqali_harakatlanish_UZ.html",
        "Avtomagistrallarda harakatlanish":
            "1_PDD/19_Avtomagistrallarda_harakatlanish_UZ.html",
        "Turar joy dahalarida harakatlanish":
            "1_PDD/20_Turar_joy_dahalarida_harakatlanish_UZ.html",
        "Tik nishablik va balandliklarda harakatlanish":
            "1_PDD/21_Tik_nishablik_va_balandliklarda_harakatlanish_UZ.html",
        "Yo‘nalishli transport vositalarining imtiyozlari":
            "1_PDD/22_Yonalishli_transport_vositalarining_imtiyozlari_UZ.html",
        "Tashqi yoritish asboblaridan foydalanish":
            "1_PDD/23_Tashqi_yoritish_asboblaridan_foydalanish_UZ.html",
        "Mexanik transport vositalarini shatakka olish":
            "1_PDD/24_Mexanik_transport_vositalarini_shatakka_olish_UZ.html",
        "Transport vositalarini boshqarishni o‘rgatish":
            "1_PDD/25_Transport_vositalarini_boshqarishni_orgatish_UZ.html",
        "Odam tashish": "1_PDD/26_Odam_tashish_UZ.html",
        "Yuk tashish": "1_PDD/27_Yuk_tashish_UZ.html",
        "Velosiped, moped va aravalar harakatlanishiga, shuningdek hayvonlarni haydab o‘tishga doir qo‘shimcha talablar":
            "1_PDD/28_Velosiped_moped_va_aravalar_harakatlanishiga_shuningdek_hayvonlarni_haydab_otishga_doir_qoshimcha_talablar_UZ.html",
        "Mansabdor shaxslarning va fuqarolarning yo‘l harakati xavfsizligini taʼminlash, transport vositalarini yo‘lga chiqarish, raqam va taniqli belgilarini o‘rnatish bo‘yicha majburiyatlari":
            "1_PDD/29_Mansabdor_shaxslarning_va_fuqarolarning_UZ.html"
      };
    }
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: AppColors.appPrimaryColor,
      appBar: AppBar(
        toolbarHeight: 60.0,
        leading: Material(
          type: MaterialType.transparency,
          child: InkWell(
            onTap: () => Navigator.pop(context),
            child: Container(
              margin: const EdgeInsets.all(10.0),
              decoration: BoxDecoration(
                color: Color(0xffDFDFDF),
                shape: BoxShape.circle,
              ),
              child: const Center(
                child: Icon(
                  Icons.arrow_back_ios_outlined,
                  size: 20.0,
                  color: Colors.black,
                ),
              ),
            ),
          ),
        ),
        title: Text(
          widget.appBarTitle,
          style: AppStyle.textStyle().copyWith(
              color: Colors.black, fontWeight: FontWeight.w600, fontSize: 21.0),
          maxLines: 2,
          textAlign: TextAlign.center,
        ),
      ),
      body: Container(
        padding: const EdgeInsets.symmetric(horizontal: 16.0),
        child: SingleChildScrollView(
          child: Column(children: [
            ...List.generate(
              paths.length,
              (index) => Column(
                children: [
                  InkWell(
                    onTap: () {
                      Navigator.push(
                        context,
                        CupertinoPageRoute(
                          builder: (context) => WebViewOfManual(
                            appBarTitle: widget.appBarTitle,
                            pathOfHTML: "${paths.values.toList()[index]}",
                          ),
                        ),
                      );
                    },
                    child: Container(
                      height: 68.0,
                      child: Row(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        children: [
                          Container(
                            height: 40.0,
                            width: 40.0,
                            margin:
                                const EdgeInsets.symmetric(horizontal: 10.0),
                            decoration: BoxDecoration(
                              shape: BoxShape.circle,
                              color: Color(0xff767680).withOpacity(0.12),
                            ),
                            child: Center(
                              child: Text(
                                "${index + 1}",
                                maxLines: 1,
                                textAlign: TextAlign.start,
                                overflow: TextOverflow.ellipsis,
                                style: AppStyle.textStyle().copyWith(
                                    color: Color(0xff282828),
                                    fontWeight: FontWeight.w400,
                                    fontSize: 16.0),
                              ),
                            ),
                          ),
                          Expanded(
                            child: Text(
                              paths.keys.toList()[index],
                              maxLines: 2,
                              textAlign: TextAlign.start,
                              overflow: TextOverflow.ellipsis,
                              style: AppStyle.textStyle().copyWith(
                                  color: Color(0xff282828),
                                  fontWeight: FontWeight.w400,
                                  fontSize: 16.0),
                            ),
                          ),
                          const Padding(
                            padding:
                                const EdgeInsets.symmetric(horizontal: 8.0),
                            child: Icon(
                              Icons.chevron_right,
                              color: AppColors.unSelectedColor,
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                  if (index != paths.length - 1)
                    const Divider(
                      height: 1.0,
                      color: Color(0XFFCACACA),
                    )
                ],
              ),
            ),
            const SizedBox(height: 60.0),
          ]),
        ),
      ),
    );
  }
}
